﻿using System;
using System.Diagnostics;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace LockDown
{
    public partial class Locked : Form
    {            
        private const int WM_CLOSE = 0x10;
        private const int SW_HIDE = 0;
        private int _LastState;
        private IntPtr _MainHandle;

        private LockDown _LockDown;

        [DllImport("User32")]
        private static extern int ShowWindow(IntPtr hwnd, int nCmdShow);

        [DllImport("user32.dll")]
        [return: MarshalAs(UnmanagedType.Bool)]
        static extern bool GetWindowPlacement(IntPtr hWnd, ref WINDOWPLACEMENT lpwndpl);

        private struct WINDOWPLACEMENT
        {
            public int length;
            public int flags;
            public int showCmd;
            public System.Drawing.Point ptMinPosition;
            public System.Drawing.Point ptMaxPosition;
            public System.Drawing.Rectangle rcNormalPosition;
        }

        public Locked(LockDown lockDown)
        {
            _LockDown = lockDown;

            InitializeComponent();
            Shown += (Locked_Shown);
            KeyPreview = true;
            KeyDown += FormKeyDown;
        }

        private void Locked_Shown(object sender, EventArgs e)
        {
            Process[] ps = Process.GetProcesses();
            for (int i = 0; i < ps.Length; i++)
            {
                if (ps[i].ProcessName.ToLower().StartsWith("adiirc"))
                {
                    _MainHandle = ps[i].MainWindowHandle;
                    WINDOWPLACEMENT placement = new WINDOWPLACEMENT();
                    placement.length = Marshal.SizeOf(placement);
                    GetWindowPlacement(_MainHandle, ref placement);
                    _LastState = placement.showCmd;
                    ShowWindow(_MainHandle, SW_HIDE);
                    break;
                }
            }
            if (_MainHandle.Equals(IntPtr.Zero))
            {
                maskedTextBox1.Text = _LockDown.Password;
                Close();
            }
        }

        protected override void WndProc(ref Message m)
        {
            if (m.Msg == WM_CLOSE)
            {
                if (String.Compare(maskedTextBox1.Text, _LockDown.Password, true) == 0)
                {
                    ShowWindow(_MainHandle, _LastState);
                    base.WndProc(ref m);
                }
                else
                {
                    Point p = new Point(Location.X - 10, Location.Y);
                    Point p2 = new Point(Location.X + 10, Location.Y);
                    ShakeWindow(p, p2, 400);
                }
            }
            else
            {
                base.WndProc(ref m);
            }
        }

        private void ShakeWindow(Point p1, Point p2, int time)
		{
			Point p = Location;
			long tLater = DateTime.Now.AddMilliseconds(time).Ticks;
            while (DateTime.Now.Ticks < tLater)
			{
				Location = p1;
				Update();
				System.Threading.Thread.Sleep(10);
				Location = p2;
				Update();
				System.Threading.Thread.Sleep(10);

			}			
			System.Threading.Thread.Sleep(10);

			Location = p;
			Refresh();
		}

        private void FormKeyDown(object Sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                Close();
            }
        }
    }
}
